<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tenant extends Model
{
    use HasFactory;

    protected $fillable = [
        'domain',
        'brand_name',
        'niche',
        'logo',
        'primary_color',
        'secondary_color',
        'phone',
        'email',
        'cta_text',
        'active',
    ];

    // Relationship: Tenant has many pages
    public function pages()
    {
        return $this->hasMany(PageContent::class);
    }
}
