<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Tenant;
use App\Models\PageContent;

class TenantSeeder extends Seeder
{
    public function run()
    {
        $tenant1 = Tenant::create([
            'domain' => 'plumber-cebu.test',
            'brand_name' => 'Cebu Plumbing Experts',
            'niche' => 'Plumbing',
            'primary_color' => '#1e90ff',
            'secondary_color' => '#0b3c5d',
            'phone' => '+639123456789',
            'email' => 'info@plumber-cebu.test',
            'cta_text' => 'Call Now',
        ]);

        PageContent::create([
            'tenant_id' => $tenant1->id,
            'slug' => 'home',
            'page_name' => 'Professional Plumbing Services in Cebu',
            'meta_title' => 'Plumber in Cebu | Cebu Plumbing Experts',
            'meta_description' => 'Looking for a trusted plumber in Cebu? Call Cebu Plumbing Experts today.',
            'keywords' => 'plumber cebu, plumbing services cebu',
            'content_html' => '<p>We provide fast, reliable plumbing services across Cebu City.</p>',
        ]);

        $tenant2 = Tenant::create([
            'domain' => 'roofing-davao.test',
            'brand_name' => 'Davao Roofing Pros',
            'niche' => 'Roofing',
            'primary_color' => '#ff6600',
            'secondary_color' => '#333333',
            'phone' => '+639987654321',
            'email' => 'info@roofing-davao.test',
            'cta_text' => 'Get a Quote',
        ]);

        PageContent::create([
            'tenant_id' => $tenant2->id,
            'slug' => 'home',
            'page_name' => 'Top Roofing Services in Davao',
            'meta_title' => 'Roofing in Davao | Davao Roofing Pros',
            'meta_description' => 'Need a reliable roofing service in Davao? Contact Davao Roofing Pros today.',
            'keywords' => 'roofing davao, roof repair davao',
            'content_html' => '<p>We specialize in roof repair, installation, and inspection across Davao City.</p>',
        ]);
    }
}